local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local bassStart = '*99 200% drunk, *99 200% tipsy'
		local bassStartReverse = '*99 -200% drunk, *99 -200% tipsy'
		local bassEnd = '*3 no drunk, *3 no tipsy'

		local Flivert = '*6 flip, *6 -100% invert'
		local FlivertHard = '*99 flip, *99 -100% invert'
		local Flivertoff = '*6 no flip, *6 no invert'
		local Flivertoffhard = '*99 no flip, *99 no invert'

		local bassStartHard = '*1000 500% drunk, *1000 500% tipsy'
		local bassStartHardReverse = '*1000 -500% drunk, *1000 -500% tipsy'
		local bassEndHard = '*11 no drunk, *11 no tipsy'

		local zoomOut = '*999 200% mini'
		local zoomOutRestore = '*8.6 no mini'

		local shortBreakStart = '*999 30% brake'
		local shortBreakEnd = '*5 no brake'

		local arrowChomp = '*10 50% flip, *10 50% reverse'
		local arrowChompRestore = '*3 no flip, *3 no reverse'

		local hardMini = function(percent)
			return '*999 ' .. percent .. '% mini'
		end

		mods = {
			--Start.
			{0, '*99 2.25x,*99 70% cover,*6 invert'},
			{1,'*6 no invert,*6 flip'},
			{1.5, Flivert},
			{2, Flivertoff},
			{4, Flivert},
			{5,'*6 no invert'},
			{5.5,'*6 invert,*6 no flip'},
			{6,'*6 no invert'},
			{7,'*6 50% alternate,*6 -50% cross,*6 50% split'},
			{7.5,'*6 no alternate,*6 no cross,*6 split'},
			{8,'*6 reverse,*6 no alternate,*6 no cross,*6 no split'},
			{9,'*6 invert'},
			{9.5,'*6 no invert,*6 flip'},
			{10,'*6 no invert,*6 no flip'},
			{12,'*6 reverse,*6 -50% alternate,*6 50% cross,*6 -50% split'},
			{13.5,'*99 split,*99 no alternate,*99 no cross'},
			{14,'*6 no split,*6 no reverse'},
			{15,'*6 invert'},
			{15.5,'*6 no invert,*6 flip'},
			{16,'*6 no flip'},
			{17,'*6 invert'},
			{17.5,'*6 no invert'},
			{18,'*6 invert'},
			{20,'*6 no invert'},
			{21,'*6 invert'},
			{21.5,'*6 no invert'},
			{22,'*6 invert'},
			{23,'*6 no invert'},
			{23.5,'*6 invert'},
			{24,'*6 no invert'},
			{25,'*6 invert'},
			{25.5,'*6 no invert'},
			{26,'*6 invert'},
			{28,'*6 no invert'},
			{28.5,'*6 invert'},
			{29,'*6 no invert'},
			{29.5,'*6 invert'},
			{30,'*6 no invert'},
			{31,'*6 invert'},
			{31.5,'*6 no invert'},
			--
			{32,'*99 2.75x', bassStart},
			{32.25, bassEnd},
			{33, bassStartReverse},
			{33.25, bassEnd},
			{34, bassStart},
			{34.25, bassEnd},
			{34.5, bassStartReverse},
			{34.75, bassEnd},
			{35, bassStart},
			{35.25, bassEnd},
			{37, bassStartReverse},
			{37.25, bassEnd},
			{38, bassStart},
			{38.25, bassEnd},
			{39, bassStartReverse},
			{39.25, bassEnd},
			{40, bassStart},
			{40.25, bassEnd},
			{41, bassStartReverse},
			{41.25, bassEnd},
			{42, bassStart},
			{42.25, bassEnd},
			{42.5, bassStartReverse},
			{42.75, bassEnd},
			{43, bassStart},
			{43.25, bassEnd},
			{45, bassStartReverse},
			{45.25, bassEnd},
			{46, bassStart},
			{46.25, bassEnd},
			{47, bassStartReverse},
			{47.25, bassEnd},
			{48, bassStart},
			{48.25, bassEnd},
			{49, bassStartReverse},
			{49.25, bassEnd},
			{50, bassStart},
			{50.25, bassEnd},
			{50.5, bassStartReverse},
			{50.75, bassEnd},
			{51, bassStart},
			{51.25, bassEnd},
			{53, bassStartReverse},
			{53.25, bassEnd},
			{54, bassStart},
			{54.25, bassEnd},
			{55, bassStartReverse},
			{55.25, bassEnd},
			{56, bassStart},
			{56.25, bassEnd},
			{57, bassStartReverse},
			{57.25, bassEnd},
			{58, bassStart},
			{58.25, bassEnd},
			{58.5, bassStartReverse},
			{58.75, bassEnd},
			{59, bassStart},
			{59.25, bassEnd},
			{61, bassStartReverse},
			{61.25, bassEnd},
			{62, bassStart},
			{62.25, bassEnd},
			--
			{64,'*99 1000% beat,*99 invert'},
			{64.5,'*1000 no beat'},
			{66,'*99 -1000% beat', FlivertHard},
			{66.5,'*1000 no beat'},
			{68,'*99 1000% beat,*99 no invert'},
			{68.5,'*1000 no beat'},
			{70,'*99 -1000% beat,*99 no flip,*99 invert'},
			{70.5,'*1000 no beat'},
			{72,'*99 1000% beat', FlivertHard},
			{72.5,'*1000 no beat'},
			{74,'*99 -1000% beat', Flivertoffhard},
			{74.5,'*1000 no beat'},
			{76,'*2 dark,*2 85% stealth,*2 blind,-100% expand'},
			{123,'*3 300% centered,*0.1 no blind,no expand'},
			{129,'*6 no centered,*99 no stealth'},
			{136,'*99 no dark,*99 flip', bassStartHard},
			{136.25, bassEndHard},
			{138, FlivertHard, bassStartHardReverse},
			{138.25, bassEndHard},
			{140,'*99 no flip,*99 invert', bassStartHard},
			{140.25, bassEndHard},
			{142,'*99 no invert', bassStartHardReverse},
			{142.25, bassEndHard},
			{144, FlivertHard, bassStartHard},
			{144.25, bassEndHard},
			{146,'*99 no invert', bassStartHardReverse},
			{146.25, bassEndHard},
			{148,'*99 invert,*99 no flip', bassStartHard},
			{148.25, bassEndHard},
			{150,'*99 no invert', bassStartHardReverse},
			{150.25, bassEndHard},
			{152,'*99 flip', bassStartHard},
			{152.25, bassEndHard},
			{154, FlivertHard, bassStartHardReverse},
			{154.25, bassEndHard},
			{156,'*99 invert,*99 no flip', bassStartHard},
			{156.25, bassEndHard},
			{158,'*99 flip,*99 no invert', bassStartHardReverse},
			{158.25, bassEndHard},
			{160,'*99 no flip', bassStartHard},
			{160.25, bassEndHard},
			{162, FlivertHard, bassStartHardReverse},
			{162.25, bassEndHard},
			{164,'*99 no flip,*99 invert', bassStartHard},
			{164.25, bassEndHard},
			{166,'*99 flip,*99 no invert', bassStartHardReverse},
			{166.25, bassEndHard},
			{168, FlivertHard, bassStartHard},
			{168.25, bassEndHard},
			{170,'*99 no flip,*99 no invert', bassStartHardReverse},
			{170.25, bassEndHard},
			{172, FlivertHard, bassStartHard},
			{172.25, bassEndHard},
			{174,'*99 no flip,*99 invert', bassStartHardReverse},
			{174.25, bassEndHard},
			{176,'*99 no invert', bassStartHard},
			{176.25, bassEndHard},
			{178, FlivertHard, bassStartHardReverse},
			{178.25, bassEndHard},
			{180,'*99 no invert', bassStartHard},
			{180.25, bassEndHard},
			{182,'*99 invert,*99 no flip', bassStartHardReverse},
			{182.25, bassEndHard},
			{184,'*99 no invert', bassStartHard},
			{184.25, bassEndHard},
			{186,'*99 flip', bassStartHardReverse},
			{186.25, bassEndHard},
			{188, FlivertHard, bassStartHard},
			{188.25, bassEndHard},
			{190,'*99 invert,*99 no flip', bassStartHardReverse},
			{190.25, bassEndHard},
			{192,'*99 flip,*99 no invert', bassStartHard},
			{192.25, bassEndHard},
			{194,'*99 no flip', bassStartHardReverse},
			{194.25, bassEndHard},
			{196, FlivertHard, bassStartHard},
			{196.25, bassEndHard},
			{198,'*99 no flip,*99 no invert', bassStartHardReverse},
			{198.25, bassEndHard},
			--
			{200,'*99 wave,*99 brake,*99 beat'},
			{216,'55% drunk,no wave,no brake,*99 1000% beat'},
			{280,'*99 no drunk,*99 no beat'},
			{296, FlivertHard, bassStartHardReverse},
			{296.25, bassEndHard},
			{298,'*99 no flip,*99 invert', bassStartHard},
			{298.25, bassEndHard},
			{300,'*99 no invert', bassStartHardReverse},
			{300.25, bassEndHard},
			{302, FlivertHard, bassStartHard},
			{302.25, bassEndHard},
			{304,'*99 no invert', bassStartHardReverse},
			{304.25, bassEndHard},
			{306,'*99 invert,*99 no flip', bassStartHard},
			{306.25, bassEndHard},
			{308,'*99 no invert', bassStartHardReverse},
			{308.25, bassEndHard},
			{310,'*99 flip', bassStartHard},
			{310.25, bassEndHard},
			{312, FlivertHard, bassStartHardReverse},
			{312.25, bassEndHard},
			{314,'*99 invert,*99 no flip', bassStartHard},
			{314.25, bassEndHard},
			{316,'*99 flip,*99 no invert', bassStartHardReverse},
			{316.25, bassEndHard},
			{318,'*99 no flip', bassStartHard},
			{318.25, bassEndHard},
			{320, FlivertHard, bassStartHardReverse},
			{320.25, bassEndHard},
			{322,'*99 no flip,*99 invert', bassStartHard},
			{322.25, bassEndHard},
			{324,'*99 flip,*99 no invert', bassStartHardReverse},
			{324.25, bassEndHard},
			{326, FlivertHard, bassStartHard},
			{326.25, bassEndHard},
			{328,'*99 no flip,*99 no invert', bassStartHardReverse},
			{328.25, bassEndHard},
			{330, FlivertHard, bassStartHard},
			{330.25, bassEndHard},
			{332,'*99 no flip,*99 invert', bassStartHardReverse},
			{332.25, bassEndHard},
			{334,'*99 no invert', bassStartHard},
			{334.25, bassEndHard},
			{336, FlivertHard, bassStartHardReverse},
			{336.25, bassEndHard},
			{338,'*99 no invert', bassStartHard},
			{338.25, bassEndHard},
			{340,'*99 invert,*99 no flip', bassStartHardReverse},
			{340.25, bassEndHard},
			{342,'*99 no invert', bassStartHard},
			{342.25, bassEndHard},
			{344,'*99 flip', bassStartHardReverse},
			{344.25, bassEndHard},
			{346, FlivertHard, bassStartHard},
			{346.25, bassEndHard},
			{348,'*99 invert,*99 no flip', bassStartHardReverse},
			{348.25, bassEndHard},
			{350,'*99 flip,*99 no invert', bassStartHard},
			{350.25, bassEndHard},
			{352,'*99 no flip', bassStartHardReverse},
			{352.25, bassEndHard},
			{354, FlivertHard, bassStartHard},
			{354.25, bassEndHard},
			{356,'*99 flip,*99 no invert', bassStartHardReverse},
			{356.25, bassEndHard},
			{358,'*99 no flip,*99 no invert', bassStartHardReverse},
			{358.25, bassEndHard},
			--360 NOSCOPED!
			{360,'*99 dark'},
			{392,'*99 no dark', bassStart},
			{392.25, bassEnd},
			{393, bassStartReverse},
			{393.25, bassEnd},
			{394, bassStart},
			{394.25, bassEnd},
			{394.5, bassStartReverse},
			{394.75, bassEnd},
			{395, bassStart},
			{395.25, bassEnd},
			{397, bassStartReverse},
			{397.25, bassEnd},
			{398, bassStart},
			{398.25, bassEnd},
			{399, bassStartReverse},
			{399.25, bassEnd},
			{400, bassStart},
			{400.25, bassEnd},
			{401, bassStartReverse},
			{401.25, bassEnd},
			{402, bassStart},
			{402.25, bassEnd},
			{402.5, bassStartReverse},
			{402.75, bassEnd},
			{403, bassStart},
			{403.25, bassEnd},
			{405, bassStartReverse},
			{405.25, bassEnd},
			{406, bassStart},
			{406.25, bassEnd},
			{407, bassStartReverse},
			{407.25, bassEnd},
			{408, bassStart},
			{408.25, bassEnd},
			{409, bassStartReverse},
			{409.25, bassEnd},
			{410, bassStart},
			{410.25, bassEnd},
			{410.5, bassStartReverse},
			{410.75, bassEnd},
			--
			{411, bassStart},
			{411.25, bassEnd},
			{413, bassStartReverse},
			{413.25, bassEnd},
			{414, bassStart},
			{414.25, bassEnd},
			{415, bassStartReverse},
			{415.25, bassEnd},
			{416, bassStart},
			{416.25, bassEnd},
			{417, bassStartReverse},
			{417.25, bassEnd},
			{418, bassStart},
			{418.25, bassEnd},
			{418.5, bassStartReverse},
			{418.75, bassEnd},
			{419, bassStart},
			{419.25, bassEnd},
			{421, bassStartReverse},
			{421.25, bassEnd},
			{422, bassStart},
			{422.25, bassEnd},
			{424,'*99 2.75x', bassStart},
			{424.25, bassEnd},
			{425, bassStartReverse},
			{425.25, bassEnd},
			{426, bassStart},
			{426.25, bassEnd},
			{426.5, bassStartReverse},
			{426.75, bassEnd},
			{427, bassStart},
			{427.25, bassEnd},
			{429, bassStartReverse},
			{429.25, bassEnd},
			{430, bassStart},
			{430.25, bassEnd},
			{431, bassStartReverse},
			{431.25, bassEnd},
			{432, bassStart},
			{432.25, bassEnd},
			{433, bassStartReverse},
			{433.25, bassEnd},
			{434, bassStart},
			{434.25, bassEnd},
			{434.5, bassStartReverse},
			{434.75, bassEnd},
			{435, bassStart},
			{435.25, bassEnd},
			{437, bassStartReverse},
			{437.25, bassEnd},
			{438, bassStart},
			{438.25, bassEnd},
			{439, bassStartReverse},
			{439.25, bassEnd},
			{440, bassStart},
			{440.25, bassEnd},
			{441, bassStartReverse},
			{441.25, bassEnd},
			{442, bassStart},
			{442.25, bassEnd},
			{442.5, bassStartReverse},
			{442.75, bassEnd},
			{443, bassStart},
			{443.25, bassEnd},
			{445, bassStartReverse},
			{445.25, bassEnd},
			{446, bassStart},
			{446.25, bassEnd},
			{447, bassStartReverse},
			{447.25, bassEnd},
			{448, bassStart},
			{448.25, bassEnd},
			{449, bassStartReverse},
			{449.25, bassEnd},
			{450, bassStart},
			{450.25, bassEnd},
			{450.5, bassStartReverse},
			{450.75, bassEnd},
			{451, bassStart},
			{451.25, bassEnd},
			{453, bassStartReverse},
			{453.25, bassEnd},
			{454, bassStart},
			{454.25, bassEndHard},
			--
			{455,'*9999 1000% beat,*99 dark'},
			{456,'*9999 no beat'},
			{479,'no dark,*0.4 -50% mini,*0.05 25% flip'},
			{487.5,'*99 no mini,*99 no flip', bassStart},
			{487.75, bassEnd},
			{488.5, bassStartReverse},
			{488.75, bassEnd},
			{489.5, bassStart},
			{489.75, bassEnd},
			{490, bassStartReverse},
			{490.25, bassEnd},
			{490.5, bassStart},
			{490.75, bassEnd},
			{492.5, bassStartReverse},
			{492.75, bassEnd},
			{493.5, bassStart},
			{493.75, bassEnd},
			{494.5, bassStartReverse},
			{494.75, bassEnd},
			{495.5, bassStart},
			{495.75, bassEnd},
			{496.5, bassStartReverse},
			{496.75, bassEnd},
			{497.5, bassStart},
			{497.75, bassEnd},
			{498, bassStartReverse},
			{498.25, bassEnd},
			{498.5, bassStart},
			{498.75, bassEnd},
			{500.5, bassStartReverse},
			{500.75, bassEnd},
			{501.5, bassStart},
			{501.75, bassEnd},
			{502.5, bassStartReverse},
			{502.75, bassEnd},
			{503.5, bassStart},
			{503.75, bassEnd},
			{504.5, bassStartReverse},
			{504.75, bassEnd},
			{505.5, bassStart},
			{505.75, bassEnd},
			{506, bassStartReverse},
			{506.25, bassEnd},
			{506.5, bassStart},
			{506.75, bassEnd},
			{508.5, bassStartReverse},
			{508.75, bassEnd},
			{509.5, bassStart},
			{509.75, bassEnd},
			{510.5, bassStartReverse},
			{510.75, bassEnd},
			{511.5, bassStart},
			{511.75, bassEnd},
			{512.5, bassStartReverse},
			{512.75, bassEnd},
			{513.5, bassStart},
			{513.75, bassEnd},
			{514, bassStartReverse},
			{514.25, bassEnd},
			{514.5, bassStart},
			{514.75, bassEnd},
			{517.5, bassStartReverse},
			{517.75, bassEnd},
			{518.5, bassStart},
			{518.75, bassEnd},
			{519.5, bassStartReverse},
			{519.75, bassEnd},
			{520, bassStart},
			{520.25, bassEnd},
			{520.5, bassStartReverse},
			{520.75, bassEnd},
			{522.5, bassStart},
			{522.75, bassEnd},
			{523.5, bassStartReverse},
			{523.75, bassEnd},
			{524.5, bassStart},
			{524.75, bassEnd},
			{525.5, bassStartReverse},
			{525.75, bassEnd},
			{526.5, bassStart},
			{526.75, bassEnd},
			{527.5, bassStartReverse},
			{527.75, bassEnd},
			{528, bassStart},
			{528.25, bassEnd},
			{528.5, bassStartReverse},
			{528.75, bassEnd},
			{530.5, bassStart},
			{530.75, bassEnd},
			{531.5, bassStartReverse},
			{531.75, bassEnd},
			{532.5, bassStart},
			{532.75, bassEnd},
			{533.5, bassStartReverse},
			{533.75, bassEnd},
			{534.5, bassStart},
			{534.75, bassEnd},
			{535.5, bassStartReverse},
			{535.75, bassEnd},
			{536, bassStart},
			{536.25, bassEnd},
			{536.5, bassStartReverse},
			{536.75, bassEnd},
			{538.5, bassStart},
			{538.75, bassEnd},
			{539.5, bassStartReverse},
			{539.75, bassEnd},
			{540.5, bassStart},
			{540.75, bassEnd},
			{541.5, bassStartReverse},
			{541.75, bassEnd},
			{542.5, bassStart},
			{542.75, bassEnd},
			{543.5, bassStartReverse},
			{543.75, bassEnd},
			{544, bassStart},
			{544.25, bassEnd}
			--End.
		}


		local introWag = function()
			p1:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(16)
			p2:wag():effectmagnitude(0, 0, -15):effectclock('beat'):effectperiod(16)
		end
		
		local coolSpinz = function()
			p1:spin():effectmagnitude(999, 0, 0):effectclock('beat'):effectperiod(1)
			p2:spin():effectmagnitude(999, 0, 0):effectclock('beat'):effectperiod(1)
		end

		local stopEffect = function()
			screen:stopeffect()
			p1:stopeffect()
			p2:stopeffect()
		end
		
		local stopEffect2 = function()
			p1:stopeffect()
			p1:rotationx(0)
			p2:stopeffect()
			p2:rotationx(0)
		end
		
		local vibrateScreen = function()
			screen:vibrate():effectmagnitude(20, 20, 20)
		end
		
		local screenQuake = function()
			screen:vibrate():effectmagnitude(20, 0, 20)
		end
		
		local screenGone = function()
			screen:smooth(5):skewx(999)
		end

		local shortTilt = function()
			for i=1, #players do
				players[i]
					:decelerate(0.10)
					:addrotationz(-20)
					:accelerate(0.10)
					:addrotationz(0)
			end
		end

		local playfieldWiggle = function()
			for i=1, #players do
				players[i]
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:accelerate(0.1)
					:skewx(0)
			end
		end

		local bassPivot = function()
			local dist = 60
			for i=1, #players do
				players[i]
					:linear(60/130 * .25)
					:addx(-dist)
					:addrotationy(-30)

					:linear(60/130 * .25)
					:addx(dist*2)
					:addrotationy(60)

					:linear(60/130 * .50)
					:addx(-dist*2)
					:addrotationy(-60)

					:linear(60/130 * .50)
					:addx(dist)
					:addrotationy(30)
			end
		end

		local switch = function()
			if GAMESTATE:GetNumPlayersEnabled() > 1 then
				local x1,x2 = p1:GetX(), p2:GetX()
				p1:x(x2)
				p2:x(x1)
			end
		end

		local rotationSwitch = function()
			for i=1, #players do
				local player = players[i]
				local xbase = player:GetX()

				player
					:decelerate(60/130)
					:x(SCREEN_CENTER_X + (SCREEN_CENTER_X - xbase))
					:addrotationy(360)

					:decelerate(60/130)
					:x(xbase)
					:addrotationy(-360)
			end
		end

		actorCmds = {
			--Lua cmd start.
			{64, vibrateScreen},
			{64.75, stopEffect},
			{66, vibrateScreen},
			{66.75, stopEffect},
			{68, vibrateScreen},
			{68.75, stopEffect},
			{70, vibrateScreen},
			{70.75, stopEffect},
			{72, vibrateScreen},
			{72.75, stopEffect},
			{74, vibrateScreen},
			{74.75, stopEffect},
			{78, introWag},
			{124, stopEffect},
			{136, screenQuake},
			{200, stopEffect},
			{216, introWag},
			{280, stopEffect},
			{296, screenQuake},
			--360 NOSCOPED!
			{360, stopEffect},
			{516.5, coolSpinz},
			{517.5, stopEffect2},
			{544.5, screenGone}
			--Lua cmd end.
		}

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
